#include "get_segment_stats_request_processor.h"

#include <crypta/lib/native/http/format.h>
#include <crypta/siberia/bin/common/ydb/requests/segment_exists_db_request.h>
#include <crypta/siberia/bin/core/lib/ydb/requests/get_segment_stats_db_request.h>

#include <library/cpp/protobuf/json/proto2json.h>

using namespace NCrypta::NSiberia;
using namespace NYdb;
using namespace NTable;

TGetSegmentStatsProcessor::TGetSegmentStatsProcessor(TYdbClient& ydbClient, const TStats::TSettings& statsSettings)
    : TBase(NLog::GetLog("get_segment_stats"), TaggedSingleton<TStats, decltype(*this)>("processors.get_segment_stats", statsSettings), ydbClient)
{}

void TGetSegmentStatsProcessor::DoProcess(NHttp::TRequestReply& reply, const TGetSegmentStatsRequest& request) {
    if (!IsSegmentExists(YdbClient, request.UserSetId, request.SegmentId)) {
        SendResponse(reply, HTTP_BAD_REQUEST, NHttp::GetSimpleResponse("Unknown segment id"));
        return;
    }

    const auto& segmentStats = GetSegmentStats(YdbClient, request.UserSetId, request.SegmentId);
    const TString response = segmentStats.Defined() ? NProtobufJson::Proto2Json(*segmentStats) : NHttp::GetSimpleResponse("No stats");
    SendResponse(reply, HTTP_OK, response);
}
