#include "get_segment_stats_request_parser.h"

#include <crypta/siberia/bin/core/lib/logic/common/helpers/cgiparam.h>

#include <library/cpp/http/misc/parsed_request.h>
#include <util/string/cast.h>

using namespace NCrypta::NSiberia;

TGetSegmentStatsRequest TGetSegmentStatsRequestParser::Parse(const TString& query, const TStringBuf& body) {
    TParsedHttpLocation httpLocation(query);

    Y_ENSURE(httpLocation.Path == "/segments/get_stats", "Not /segments/get_stats request");

    return Parse(TCgiParameters(httpLocation.Cgi), body);
}

TGetSegmentStatsRequest TGetSegmentStatsRequestParser::Parse(const TCgiParameters& cgi, const TStringBuf& body) {
    Y_UNUSED(body);

    return {
        .UserSetId = NCgiParamUtils::GetUserSetId(cgi),
        .SegmentId = NCgiParamUtils::GetSegmentId(cgi)
    };
}
