#include "get_user_set_request_processor.h"

#include <crypta/lib/native/http/format.h>
#include <crypta/siberia/bin/common/ydb/parse_utils/parse_utils.h>
#include <crypta/siberia/bin/common/ydb/requests/get_user_set_db_request.h>

#include <library/cpp/protobuf/json/proto2json.h>

using namespace NCrypta::NSiberia;
using namespace NYdb;


TGetUserSetProcessor::TGetUserSetProcessor(TYdbClient& ydbClient, const ::TStats::TSettings& statsSettings)
    : TBase(NLog::GetLog("get_user_set"), TaggedSingleton<::TStats, decltype(*this)>("processors.get_user_set", statsSettings), ydbClient)
{}

void TGetUserSetProcessor::DoProcess(NHttp::TRequestReply& reply, const TGetUserSetRequest& request) {
    const auto& userSet = GetUserSet(YdbClient, request.UserSetId);
    if (userSet.Defined()) {
        SendResponse(reply, HTTP_OK, NProtobufJson::Proto2Json(*userSet));
    } else {
        SendResponse(reply, HTTP_NOT_FOUND, NHttp::GetSimpleResponse("Not Found"));
    }
}

