#include "get_user_set_stats_request_parser.h"

#include <crypta/siberia/bin/core/lib/logic/common/helpers/cgiparam.h>

#include <library/cpp/http/misc/parsed_request.h>
#include <util/string/cast.h>

using namespace NCrypta::NSiberia;

TGetUserSetStatsRequest TGetUserSetStatsRequestParser::Parse(const TString& query, const TStringBuf& body) {
    TParsedHttpLocation httpLocation(query);

    Y_ENSURE(httpLocation.Path == "/user_sets/get_stats", "Not /user_sets/get_stats request");

    return Parse(TCgiParameters(httpLocation.Cgi), body);
}

TGetUserSetStatsRequest TGetUserSetStatsRequestParser::Parse(const TCgiParameters& cgi, const TStringBuf& body) {
    Y_UNUSED(body);

    return {.UserSetId = NCgiParamUtils::GetUserSetId(cgi)};
}
