#include "get_user_stats_request_parser.h"

#include <crypta/lib/native/cgiparam/cgiparam.h>

#include <library/cpp/http/misc/parsed_request.h>
#include <util/string/cast.h>

using namespace NCrypta;
using namespace NCrypta::NSiberia;

TGetUserStatsRequest TGetUserStatsRequestParser::Parse(const TString& query, const TStringBuf& body) {
    TParsedHttpLocation httpLocation(query);

    Y_ENSURE(httpLocation.Path == "/users/get_stats", "Not /users/get_stats request");

    return Parse(TCgiParameters(httpLocation.Cgi), body);
}

TGetUserStatsRequest TGetUserStatsRequestParser::Parse(const TCgiParameters& cgi, const TStringBuf& body) {
    Y_UNUSED(body);

    return {.Yandexuid = NCgiParam::Get<ui64>(cgi, "yandexuid")};
}
