#include "list_segment_users_request_processor.h"

#include <crypta/siberia/bin/core/lib/logic/common/helpers/users_serializer.h>
#include <crypta/siberia/bin/core/lib/ydb/requests/list_segment_users_db_request.h>

using namespace NCrypta::NSiberia;

TListSegmentUsersProcessor::TListSegmentUsersProcessor(TYdbClient& ydbClient, const TStats::TSettings& statsSettings)
    : TBase(NLog::GetLog("list_segment_users"), TaggedSingleton<TStats, decltype(*this)>("processors.list_segment_users", statsSettings), ydbClient)
{}

void TListSegmentUsersProcessor::DoProcess(NHttp::TRequestReply& reply, const TListSegmentUsersRequest& request) {
    const auto& users = GetSegmentUsers(YdbClient, request.UserSetId, request.SegmentId, request.LastUserId, request.Limit);
    SendResponse(reply, HTTP_OK, NUsersSerializer::Serialize(users));
}
