#pragma once

#include <crypta/lib/native/ydb/ydb_client.h>
#include <crypta/siberia/bin/core/lib/logic/common/request_processor/user_set_request_processor.h>
#include <crypta/siberia/bin/core/lib/logic/list_segment_users/request/list_segment_users_request.h>
#include <crypta/siberia/bin/core/lib/logic/list_segment_users/request/list_segment_users_request_parser.h>

namespace NCrypta::NSiberia {
    class TListSegmentUsersProcessor : public TUserSetRequestProcessor<TListSegmentUsersRequest, TListSegmentUsersRequestParser, TMustBeMaterializedReadyPolicy> {
        using TBase = TUserSetRequestProcessor<TListSegmentUsersRequest, TListSegmentUsersRequestParser, TMustBeMaterializedReadyPolicy>;

    public:
        TListSegmentUsersProcessor(TYdbClient& ydbClient, const TStats::TSettings& statsSettings);

    private:
        void DoProcess(NHttp::TRequestReply& reply, const TListSegmentUsersRequest& request) override final;
    };
}
