#include "make_segment_request_processor.h"

#include <crypta/lib/native/http/format.h>
#include <crypta/siberia/bin/common/data/proto/segment.pb.h>
#include <crypta/siberia/bin/common/segmentation/engine/helpers.h>
#include <crypta/siberia/bin/core/lib/ydb/requests/insert_segment_db_request.h>

#include <library/cpp/protobuf/json/proto2json.h>

using namespace NCrypta;
using namespace NCrypta::NSiberia;

TMakeSegmentProcessor::TMakeSegmentProcessor(TYdbClient& ydbClient, TSegmentationSender& segmentationSender, const TStats::TSettings& statsSettings)
    : TBase(NLog::GetLog("make_segment"), TaggedSingleton<TStats, decltype(*this)>("processors.make_segment", statsSettings), ydbClient)
    , SegmentationSender(segmentationSender)
{}

void TMakeSegmentProcessor::DoProcess(NHttp::TRequestReply& reply, const TMakeSegmentRequest& request) {
    const auto& parsingResult = NRuleParser::Parse(request.Rule);
    if (!parsingResult.Expression.Defined()) {
        SendResponse(reply, HTTP_BAD_REQUEST, NHttp::GetSimpleResponse(parsingResult.ErrorMessage));
        return;
    }

    // TODO(kolontaev): Сделать статус в виде enum class
    TSegment segment;
    segment.SetTitle(request.Title);
    segment.SetRule(request.Rule);
    segment.SetStatus("in_progress");
    segment.SetCreationTs(TInstant::Now().Seconds());

    InsertSegment(YdbClient, request.UserSetId, segment);
    SegmentationSender.Segmentate(request.UserSetId, FromString<TSegmentId>(segment.GetId()));
    SendResponse(reply, HTTP_OK, NProtobufJson::Proto2Json(segment));
}
