#pragma once

#include <crypta/lib/native/ydb/ydb_client.h>
#include <crypta/siberia/bin/core/lib/command_senders/segmentation_sender.h>
#include <crypta/siberia/bin/core/lib/logic/common/request_processor/user_set_request_processor.h>
#include <crypta/siberia/bin/core/lib/logic/make_segment/request/make_segment_request_parser.h>

namespace NCrypta::NSiberia {
    class TMakeSegmentProcessor : public TUserSetRequestProcessor<TMakeSegmentRequest, TMakeSegmentRequestParser, TMustBeMaterializedReadyPolicy> {
        using TBase = TUserSetRequestProcessor<TMakeSegmentRequest, TMakeSegmentRequestParser, TMustBeMaterializedReadyPolicy>;

    public:
        TMakeSegmentProcessor(TYdbClient& ydbClient, TSegmentationSender& segmentationSender, const TStats::TSettings& statsSettings);

    private:
        void DoProcess(NHttp::TRequestReply& reply, const TMakeSegmentRequest& request) override final;

        TSegmentationSender& SegmentationSender;
    };
}
