#include "make_segment_request_parser.h"

#include <crypta/lib/native/cgiparam/cgiparam.h>
#include <crypta/siberia/bin/core/lib/logic/common/helpers/cgiparam.h>

#include <library/cpp/http/misc/parsed_request.h>
#include <util/string/cast.h>

using namespace NCrypta;
using namespace NCrypta::NSiberia;

TMakeSegmentRequest TMakeSegmentRequestParser::Parse(const TString& query, const TStringBuf& body) {
    TParsedHttpLocation httpLocation(query);

    Y_ENSURE(httpLocation.Path == "/segments/make", "Not /segments/make request");

    return Parse(TCgiParameters(httpLocation.Cgi), body);
}

TMakeSegmentRequest TMakeSegmentRequestParser::Parse(const TCgiParameters& cgi, const TStringBuf& body) {
    Y_UNUSED(body);

    return {
        .UserSetId = NCgiParamUtils::GetUserSetId(cgi),
        .Title = NCgiParam::GetNonEmptyString(cgi, "title"),
        .Rule = NCgiParam::GetNonEmptyString(cgi, "rule")
    };
}
