#include "ping_request_processor.h"

#include <crypta/lib/native/http/format.h>

#include <util/string/builder.h>

using namespace NCrypta::NSiberia;

TPingProcessor::TPingProcessor(const NTvmAuth::TTvmClient& tvmClient, const TStats::TSettings& statsSettings)
    : TBase(NLog::GetLog("ping"), TaggedSingleton<TStats, decltype(*this)>("processors.ping", statsSettings))
    , TvmClient(tvmClient)
{}

void TPingProcessor::Process(NHttp::TRequestReply& reply, const TPingRequest& request) {
    Y_UNUSED(request);

    const auto tvmStatus = TvmClient.GetStatus();
    if (tvmStatus == NTvmAuth::TClientStatus::Error) {
        SendResponse(reply, HTTP_INTERNAL_SERVER_ERROR, NHttp::GetSimpleResponse(TStringBuilder() << "Bad TVM client status: " << tvmStatus.GetCode()));
        return;
    }

    SendResponse(reply, HTTP_OK, NHttp::GetSimpleResponse("OK"));
}
