#include "ping_request_parser.h"

#include <library/cpp/http/misc/parsed_request.h>
#include <util/string/cast.h>

using namespace NCrypta::NSiberia;

TPingRequest TPingRequestParser::Parse(const TString& query, const TStringBuf& body) {
    TParsedHttpLocation httpLocation(query);

    Y_ENSURE(httpLocation.Path == "/ping", "Not /ping request");

    return Parse(TCgiParameters(httpLocation.Cgi), body);
}

TPingRequest TPingRequestParser::Parse(const TCgiParameters& cgi, const TStringBuf& body) {
    Y_UNUSED(body);

    TPingRequest request;
    request.User = cgi.Get("@client");

    return request;
}
