#include "remove_segments_request_processor.h"

#include <crypta/lib/native/http/format.h>
#include <crypta/siberia/bin/core/lib/ydb/requests/remove_segments_db_request.h>

using namespace NCrypta::NSiberia;

TRemoveSegmentsProcessor::TRemoveSegmentsProcessor(TYdbClient& ydbClient, TMutationSender& mutationSender, const TStats::TSettings& statsSettings)
    : TBase(NLog::GetLog("remove_segments"), TaggedSingleton<TStats, decltype(*this)>("processors.remove_segments", statsSettings), ydbClient)
    , MutationSender(mutationSender)
{}

void TRemoveSegmentsProcessor::DoProcess(NHttp::TRequestReply& reply, const TRemoveSegmentsRequest& request) {
    RemoveSegments(YdbClient, request.UserSetId, request.SegmentIds);

    for (const auto& segmentId : request.SegmentIds) {
        MutationSender.RemoveSegmentData(request.UserSetId, segmentId);
    }

    SendResponse(reply, HTTP_OK, NHttp::GetSimpleResponse("Successfully removed"));
}
