#pragma once

#include <crypta/lib/native/ydb/ydb_client.h>
#include <crypta/siberia/bin/core/lib/logic/common/request_processor/user_set_request_processor.h>
#include <crypta/siberia/bin/core/lib/logic/remove_segments/request/remove_segments_request.h>
#include <crypta/siberia/bin/core/lib/logic/remove_segments/request/remove_segments_request_parser.h>
#include <crypta/siberia/bin/core/lib/command_senders/mutation_sender.h>

namespace NCrypta::NSiberia {
    class TRemoveSegmentsProcessor : public TUserSetRequestProcessor<TRemoveSegmentsRequest, TRemoveSegmentsRequestParser, TMustBeMaterializedReadyPolicy> {
        using TBase = TUserSetRequestProcessor<TRemoveSegmentsRequest, TRemoveSegmentsRequestParser, TMustBeMaterializedReadyPolicy>;

    public:
        TRemoveSegmentsProcessor(TYdbClient& ydbClient, TMutationSender& mutationSender, const TStats::TSettings& statsSettings);

    private:
        void DoProcess(NHttp::TRequestReply& reply, const TRemoveSegmentsRequest& request) override final;

        TMutationSender& MutationSender;
    };
}
