#include "remove_segments_request_parser.h"

#include <crypta/siberia/bin/core/lib/logic/common/helpers/cgiparam.h>

#include <library/cpp/http/misc/parsed_request.h>
#include <util/string/cast.h>
#include <util/string/split.h>

using namespace NCrypta::NSiberia;

namespace {
    TVector<TSegmentId> ParseSegmentIds(const TStringBuf& body) {
        TVector<TSegmentId> segmentIds;
        StringSplitter(body).Split(',').ParseInto(&segmentIds);
        Y_ENSURE(!segmentIds.empty(), "No segment ids found");
        return segmentIds;
    }
}

TRemoveSegmentsRequest TRemoveSegmentsRequestParser::Parse(const TString& query, const TStringBuf& body) {
    TParsedHttpLocation httpLocation(query);

    Y_ENSURE(httpLocation.Path == "/segments/remove", "Not /segments/remove request");

    return Parse(TCgiParameters(httpLocation.Cgi), body);
}

TRemoveSegmentsRequest TRemoveSegmentsRequestParser::Parse(const TCgiParameters& cgi, const TStringBuf& body) {
    return {
        .UserSetId = NCgiParamUtils::GetUserSetId(cgi),
        .SegmentIds = ParseSegmentIds(body)
    };
}
