#include "remove_user_set_request_processor.h"

#include <crypta/lib/native/http/format.h>
#include <crypta/siberia/bin/common/data/helpers/user_set_helpers.h>
#include <crypta/siberia/bin/core/lib/ydb/requests/remove_user_set_db_request.h>

using namespace NCrypta;
using namespace NCrypta::NSiberia;

TRemoveUserSetProcessor::TRemoveUserSetProcessor(TYdbClient& ydbClient, TMutationSender& mutationSender, const TStats::TSettings& statsSettings)
    : TBase(NLog::GetLog("remove_user_set"), TaggedSingleton<TStats, decltype(*this)>("processors.remove_user_set", statsSettings), ydbClient)
    , MutationSender(mutationSender)
{}

void TRemoveUserSetProcessor::DoProcess(NHttp::TRequestReply& reply, const TRemoveUserSetRequest& request) {
    const auto& removedUserSet = RemoveUserSet(YdbClient, request.UserSetId);
    if (removedUserSet.Defined()) {
        if (NUserSetHelpers::IsMaterialized(*removedUserSet) && !NUserSetHelpers::IsMetaDataOnly(*removedUserSet)) {
            MutationSender.RemoveUserSetData(request.UserSetId);
        }
        SendResponse(reply, HTTP_OK, NHttp::GetSimpleResponse(TStringBuilder() << "User set '" << request.UserSetId << "' is successfully removed"));
    } else {
        SendResponse(reply, HTTP_NOT_FOUND, NHttp::GetSimpleResponse(TStringBuilder() << "Uset set '" << request.UserSetId << "' not found"));
    }
}
