#pragma once

#include <crypta/lib/native/ydb/ydb_client.h>
#include <crypta/siberia/bin/core/lib/command_senders/mutation_sender.h>
#include <crypta/siberia/bin/core/lib/logic/common/request_processor/user_set_request_processor.h>
#include <crypta/siberia/bin/core/lib/logic/remove_user_set/request/remove_user_set_request.h>
#include <crypta/siberia/bin/core/lib/logic/remove_user_set/request/remove_user_set_request_parser.h>

namespace NCrypta::NSiberia {
    class TRemoveUserSetProcessor : public TUserSetRequestProcessor<TRemoveUserSetRequest, TRemoveUserSetRequestParser> {
        using TBase = TUserSetRequestProcessor<TRemoveUserSetRequest, TRemoveUserSetRequestParser>;

    public:
        TRemoveUserSetProcessor(TYdbClient& ydbClient, TMutationSender& mutationSender, const TStats::TSettings& statsSettings);

    private:
        void DoProcess(NHttp::TRequestReply& reply, const TRemoveUserSetRequest& request) override final;

        TMutationSender& MutationSender;
    };
}
