#include "remove_user_set_data_request_processor.h"

#include <crypta/lib/native/http/format.h>
#include <crypta/siberia/bin/common/data/helpers/user_set_helpers.h>
#include <crypta/siberia/bin/common/ydb/requests/update_user_set_db_request.h>

using namespace NCrypta;
using namespace NCrypta::NSiberia;

TRemoveUserSetDataProcessor::TRemoveUserSetDataProcessor(TYdbClient& ydbClient, TMutationSender& mutationSender, const TStats::TSettings& statsSettings)
    : TBase(NLog::GetLog("remove_user_set_data"), TaggedSingleton<TStats, decltype(*this)>("processors.remove_user_set_data", statsSettings), ydbClient)
    , MutationSender(mutationSender)
{}

void TRemoveUserSetDataProcessor::DoProcess(NHttp::TRequestReply& reply, const TRemoveUserSetDataRequest& request) {
    UpdateUserSet(YdbClient, request.UserSetId, {.Status = NUserSetHelpers::USER_SET_STATUS.GetMetaDataOnly()});
    MutationSender.RemoveUserSetData(request.UserSetId);
    SendResponse(reply, HTTP_OK, NHttp::GetSimpleResponse(TStringBuilder() << "Data of uset set '" << request.UserSetId << "' is successfully removed"));
}
