#pragma once

#include <crypta/lib/native/ydb/ydb_client.h>
#include <crypta/siberia/bin/core/lib/command_senders/mutation_sender.h>
#include <crypta/siberia/bin/core/lib/logic/common/request_processor/user_set_request_processor.h>
#include <crypta/siberia/bin/core/lib/logic/remove_user_set_data/request/remove_user_set_data_request.h>
#include <crypta/siberia/bin/core/lib/logic/remove_user_set_data/request/remove_user_set_data_request_parser.h>

namespace NCrypta::NSiberia {
    class TRemoveUserSetDataProcessor : public TUserSetRequestProcessor<TRemoveUserSetDataRequest, TRemoveUserSetDataRequestParser, TMustBeMaterializedReadyPolicy> {
        using TBase = TUserSetRequestProcessor<TRemoveUserSetDataRequest, TRemoveUserSetDataRequestParser, TMustBeMaterializedReadyPolicy>;

    public:
        TRemoveUserSetDataProcessor(TYdbClient& ydbClient, TMutationSender& mutationSender, const TStats::TSettings& statsSettings);

    private:
        void DoProcess(NHttp::TRequestReply& reply, const TRemoveUserSetDataRequest& request) override final;

        TMutationSender& MutationSender;
    };
}
