#include "remove_user_set_data_request_parser.h"

#include <crypta/siberia/bin/core/lib/logic/common/helpers/cgiparam.h>

#include <library/cpp/http/misc/parsed_request.h>
#include <util/string/cast.h>

using namespace NCrypta::NSiberia;

TRemoveUserSetDataRequest TRemoveUserSetDataRequestParser::Parse(const TString& query, const TStringBuf& body) {
    TParsedHttpLocation httpLocation(query);
    Y_ENSURE(httpLocation.Path == "/user_sets/remove_data", "Not /user_sets/remove_data request");
    return Parse(TCgiParameters(httpLocation.Cgi), body);
}

TRemoveUserSetDataRequest TRemoveUserSetDataRequestParser::Parse(const TCgiParameters& cgi, const TStringBuf& body) {
    Y_UNUSED(body);

    return {.UserSetId = NCgiParamUtils::GetUserSetId(cgi)};
}
