#include "request_processor_factory.h"

#include <crypta/siberia/bin/core/lib/logic/add_user_set/add_user_set_request_processor.h>
#include <crypta/siberia/bin/core/lib/logic/add_users/add_users_request_processor.h>
#include <crypta/siberia/bin/core/lib/logic/describe_ids/describe_ids_request_processor.h>
#include <crypta/siberia/bin/core/lib/logic/describe_segment/describe_segment_request_processor.h>
#include <crypta/siberia/bin/core/lib/logic/describe_user_set/describe_user_set_request_processor.h>
#include <crypta/siberia/bin/core/lib/logic/get_segment_stats/get_segment_stats_request_processor.h>
#include <crypta/siberia/bin/core/lib/logic/get_user_set/get_user_set_request_processor.h>
#include <crypta/siberia/bin/core/lib/logic/get_user_set_stats/get_user_set_stats_request_processor.h>
#include <crypta/siberia/bin/core/lib/logic/get_user_stats/get_user_stats_request_processor.h>
#include <crypta/siberia/bin/core/lib/logic/list_segment_users/list_segment_users_request_processor.h>
#include <crypta/siberia/bin/core/lib/logic/make_segment/make_segment_request_processor.h>
#include <crypta/siberia/bin/core/lib/logic/ping/ping_request_processor.h>
#include <crypta/siberia/bin/core/lib/logic/remove_segments/remove_segments_request_processor.h>
#include <crypta/siberia/bin/core/lib/logic/remove_user_set/remove_user_set_request_processor.h>
#include <crypta/siberia/bin/core/lib/logic/remove_user_set_data/remove_user_set_data_request_processor.h>
#include <crypta/siberia/bin/core/lib/logic/search_segments/search_segments_request_processor.h>
#include <crypta/siberia/bin/core/lib/logic/search_users/search_users_request_processor.h>
#include <crypta/siberia/bin/core/lib/logic/update_user_set/update_user_set_request_processor.h>
#include <crypta/siberia/bin/core/lib/logic/version/version_request_processor.h>

#include <library/cpp/http/misc/parsed_request.h>

using namespace NCrypta::NSiberia;

TRequestProcessorFactory::TRequestProcessorFactory(
    TYdbClient& ydbClient,
    TMutationSender& mutationSender,
    TDescribingSender& describingSender,
    TDescribingSender& slowDescribingSender,
    TSegmentationSender& segmentationSender,
    const TProcessorsConfig& processorsConfig,
    const NTvmAuth::TTvmClient& tvmClient,
    const TStats::TSettings& statsSettings
)
    : YdbClient(ydbClient)
    , MutationSender(mutationSender)
    , DescribingSender(describingSender)
    , SlowDescribingSender(slowDescribingSender)
    , SegmentationSender(segmentationSender)
    , ProcessorsConfig(processorsConfig)
    , TvmClient(tvmClient)
    , StatsSettings(statsSettings)
{}

IRequestProcessor* TRequestProcessorFactory::GetProcessor(const TStringBuf& method, const TStringBuf& service, const TClient& client) {
    if (method == "GET" && service == "version") {
        static TVersionProcessor versionProcessor(StatsSettings);
        return &versionProcessor;
    }
    if (method == "GET" && service == "ping") {
        static TPingProcessor pingProcessor(TvmClient, StatsSettings);
        return &pingProcessor;
    }

    if (!client.GetPermissions().GetAllowed()) {
        ythrow TNotAllowedException() << "Permission denied for this TVM id";
    }

    if (method == "GET" && service == "users/search") {
        static TSearchUsersProcessor searchUsersProcessor(YdbClient, StatsSettings);
        return &searchUsersProcessor;
    } else if (method == "POST" && service == "users/add") {
        static TAddUsersProcessor addUsersProcessor(YdbClient, StatsSettings);
        return &addUsersProcessor;
    } else if (method == "POST" && service == "user_sets/add") {
        static TAddUserSetProcessor addUserSetProcessor(YdbClient, StatsSettings, ProcessorsConfig.GetUserSet().GetMinMaterializedTtlSeconds());
        return &addUserSetProcessor;
    } else if (method == "GET" && service == "user_sets/get") {
        static TGetUserSetProcessor getUserSetProcessor(YdbClient, StatsSettings);
        return &getUserSetProcessor;
    } else if (method == "POST" && service == "user_sets/update") {
        static TUpdateUserSetProcessor updateUserSetProcessor(YdbClient, StatsSettings);
        return &updateUserSetProcessor;
    } else if (method == "DELETE" && service == "user_sets/remove") {
        static TRemoveUserSetProcessor removeUserSetProcessor(YdbClient, MutationSender, StatsSettings);
        return &removeUserSetProcessor;
    } else if (method == "DELETE" && service == "user_sets/remove_data") {
        static TRemoveUserSetDataProcessor removeUserSetDataProcessor(YdbClient, MutationSender, StatsSettings);
        return &removeUserSetDataProcessor;
    } else if (method == "POST" && service == "user_sets/describe") {
        static TDescribeUserSetProcessor describeUserSetProcessor(YdbClient, DescribingSender, StatsSettings);
        return &describeUserSetProcessor;
    } else if (method == "POST" && service == "user_sets/describe_ids") {
        static TDescribeIdsProcessor describeIdsProcessor(YdbClient, DescribingSender, SlowDescribingSender, StatsSettings, ProcessorsConfig.GetDescribing().GetMaxIdsCount(), ProcessorsConfig.GetUserSet().GetNotMaterializedTtlSeconds());
        return &describeIdsProcessor;
    } else if (method == "GET" && service == "user_sets/get_stats") {
        static TGetUserSetStatsProcessor getUserSetStatsProcessor(YdbClient, StatsSettings);
        return &getUserSetStatsProcessor;
    } else if (method == "GET" && service == "segments/search") {
        static TSearchSegmentsProcessor searchSegmentsProcessor(YdbClient, StatsSettings);
        return &searchSegmentsProcessor;
    } else if (method == "POST" && service == "segments/remove") {
        static TRemoveSegmentsProcessor removeSegmentsProcessor(YdbClient, MutationSender, StatsSettings);
        return &removeSegmentsProcessor;
    } else if (method == "GET" && service == "segments/list_users") {
        static TListSegmentUsersProcessor listSegmentUsersProcessor(YdbClient, StatsSettings);
        return &listSegmentUsersProcessor;
    } else if (method == "POST" && service == "segments/describe") {
        static TDescribeSegmentProcessor describeSegmentProcessor(YdbClient, DescribingSender, StatsSettings);
        return &describeSegmentProcessor;
    } else if (method == "GET" && service == "users/get_stats") {
        static TGetUserStatsProcessor getUserStatsProcessor(YdbClient, StatsSettings);
        return &getUserStatsProcessor;
    } else if (method == "GET" && service == "segments/get_stats") {
        static TGetSegmentStatsProcessor getSegmentStatsProcessor(YdbClient, StatsSettings);
        return &getSegmentStatsProcessor;
    } else if (method == "POST" && service == "segments/make") {
        static TMakeSegmentProcessor makeSegmentProcessor(YdbClient, SegmentationSender, StatsSettings);
        return &makeSegmentProcessor;
    }

    return nullptr;
}
