#pragma once

#include <crypta/lib/native/stats/stats.h>
#include <crypta/lib/native/ydb/ydb_client.h>
#include <crypta/siberia/bin/core/lib/command_senders/describing_sender.h>
#include <crypta/siberia/bin/core/lib/command_senders/mutation_sender.h>
#include <crypta/siberia/bin/core/lib/command_senders/segmentation_sender.h>
#include <crypta/siberia/bin/core/lib/logic/common/request_processor/request_processor.h>
#include <crypta/siberia/bin/core/lib/configs/proto/clients/client.pb.h>
#include <crypta/siberia/bin/core/lib/configs/proto/processors_config.pb.h>

#include <library/cpp/http/misc/parsed_request.h>
#include <library/cpp/tvmauth/client/facade.h>

namespace NCrypta::NSiberia {
    class TRequestProcessorFactory {
    public:
        class TNotAllowedException : public yexception {
        };

        TRequestProcessorFactory(
            TYdbClient& ydbClient,
            TMutationSender& mutationSender,
            TDescribingSender& describingSender,
            TDescribingSender& slowDescribingSender,
            TSegmentationSender& segmentationSender,
            const TProcessorsConfig& processorsConfig,
            const NTvmAuth::TTvmClient& tvmClient,
            const TStats::TSettings& statsSettings
        );

        IRequestProcessor* GetProcessor(const TStringBuf& method, const TStringBuf& service, const TClient& client);

    private:
        TYdbClient& YdbClient;
        TMutationSender& MutationSender;
        TDescribingSender& DescribingSender;
        TDescribingSender& SlowDescribingSender;
        TSegmentationSender& SegmentationSender;
        const TProcessorsConfig& ProcessorsConfig;
        const NTvmAuth::TTvmClient& TvmClient;
        const TStats::TSettings& StatsSettings;
    };
}
