#include "search_segments_request_parser.h"

#include <crypta/lib/native/cgiparam/cgiparam.h>
#include <crypta/siberia/bin/core/lib/logic/common/helpers/cgiparam.h>

#include <library/cpp/http/misc/parsed_request.h>
#include <util/string/cast.h>

using namespace NCrypta;
using namespace NCrypta::NSiberia;

TSearchSegmentsRequest TSearchSegmentsRequestParser::Parse(const TString& query, const TStringBuf& body) {
    TParsedHttpLocation httpLocation(query);

    Y_ENSURE(httpLocation.Path == "/segments/search", "Not /segments/search request");

    return Parse(TCgiParameters(httpLocation.Cgi), body);
}

TSearchSegmentsRequest TSearchSegmentsRequestParser::Parse(const TCgiParameters& cgi, const TStringBuf& body) {
    Y_UNUSED(body);

    return {
        .UserSetId = NCgiParamUtils::GetUserSetId(cgi),
        .LastSegmentId = NCgiParam::GetOptional<TSegmentId>(cgi, "last_segment_id").GetOrElse(0),
        .Limit = NCgiParamUtils::GetLimit(cgi).GetOrElse(100),
    };
}
