#include "search_segments_request_processor.h"

#include <crypta/siberia/bin/core/lib/ydb/requests/search_segments_db_request.h>

#include <library/cpp/protobuf/json/proto2json.h>

using namespace NCrypta::NSiberia;

TSearchSegmentsProcessor::TSearchSegmentsProcessor(TYdbClient& ydbClient, const TStats::TSettings& statsSettings)
    : TBase(NLog::GetLog("search_segments"), TaggedSingleton<TStats, decltype(*this)>("processors.search_segments", statsSettings), ydbClient)
{}

void TSearchSegmentsProcessor::DoProcess(NHttp::TRequestReply& reply, const TSearchSegmentsRequest& request) {
    const auto& segments = SearchSegments(YdbClient, request.UserSetId, request.LastSegmentId, request.Limit);
    SendResponse(reply, HTTP_OK, NProtobufJson::Proto2Json(segments));
}
