#pragma once

#include <crypta/lib/native/ydb/ydb_client.h>
#include <crypta/siberia/bin/core/lib/logic/common/request_processor/user_set_request_processor.h>
#include <crypta/siberia/bin/core/lib/logic/search_segments/request/search_segments_request.h>
#include <crypta/siberia/bin/core/lib/logic/search_segments/request/search_segments_request_parser.h>

namespace NCrypta::NSiberia {
    class TSearchSegmentsProcessor : public TUserSetRequestProcessor<TSearchSegmentsRequest, TSearchSegmentsRequestParser, TMustBeMaterializedReadyPolicy> {
        using TBase = TUserSetRequestProcessor<TSearchSegmentsRequest, TSearchSegmentsRequestParser, TMustBeMaterializedReadyPolicy>;

    public:
        TSearchSegmentsProcessor(TYdbClient& ydbClient, const TStats::TSettings& statsSettings);

    private:
        void DoProcess(NHttp::TRequestReply& reply, const TSearchSegmentsRequest& request) override final;
    };
}
