#include "search_users_request_processor.h"

#include <crypta/siberia/bin/core/lib/logic/common/helpers/users_serializer.h>
#include <crypta/siberia/bin/core/lib/ydb/requests/search_users_db_request.h>

using namespace NCrypta::NSiberia;

TSearchUsersProcessor::TSearchUsersProcessor(TYdbClient& ydbClient, const TStats::TSettings& statsSettings)
    : TBase(NLog::GetLog("search_users"), TaggedSingleton<TStats, decltype(*this)>("processors.search_users", statsSettings), ydbClient)
{}

void TSearchUsersProcessor::DoProcess(NHttp::TRequestReply& reply, const TSearchUsersRequest& request) {
    const auto& users = SearchUsers(YdbClient, request.UserSetId, request.LastUserId, request.Limit);
    SendResponse(reply, HTTP_OK, NUsersSerializer::Serialize(users));
}
