#include "update_user_set_request_parser.h"

#include <crypta/lib/native/cgiparam/cgiparam.h>
#include <crypta/lib/native/time/shifted_clock.h>
#include <crypta/siberia/bin/common/data/helpers/user_set_helpers.h>
#include <crypta/siberia/bin/core/lib/logic/common/helpers/cgiparam.h>

#include <library/cpp/http/misc/parsed_request.h>
#include <market/library/maybe_monad/maybe_monad.h>

#include <util/datetime/base.h>
#include <util/string/cast.h>

using namespace NCrypta;
using namespace NCrypta::NSiberia;

TUpdateUserSetRequest TUpdateUserSetRequestParser::Parse(const TString& query, const TStringBuf& body) {
    TParsedHttpLocation httpLocation(query);
    Y_ENSURE(httpLocation.Path == "/user_sets/update", "Not /user_sets/update request");
    return Parse(TCgiParameters(httpLocation.Cgi), body);
}

TUpdateUserSetRequest TUpdateUserSetRequestParser::Parse(const TCgiParameters& cgi, const TStringBuf& body) {
    Y_UNUSED(body);

    TUpdateUserSetRequest request;
    request.UserSetId = NCgiParamUtils::GetUserSetId(cgi);

    request.UpdateInfo.Title = NCgiParam::GetOptional<TString>(cgi, "title");
    Y_ENSURE(!request.UpdateInfo.Title.Defined() || !request.UpdateInfo.Title->empty(), "Param 'title' is empty");

    request.UpdateInfo.Status = NCgiParam::GetOptional<TString>(cgi, "status");
    Y_ENSURE(!request.UpdateInfo.Status.Defined() || NUserSetHelpers::IsValidUserSetStatus(*request.UpdateInfo.Status), "Invalid 'status'");

    request.UpdateInfo.ExpirationTime = Map(NCgiParam::GetOptional<ui64>(cgi, "ttl"), [](ui64 ttl) { return TShiftedClock::Now() + TDuration::Seconds(ttl); });

    return request;
}
