#include "update_user_set_request_processor.h"

#include <crypta/lib/native/http/format.h>
#include <crypta/siberia/bin/common/data/helpers/user_set_helpers.h>
#include <crypta/siberia/bin/common/ydb/requests/update_user_set_db_request.h>


using namespace NCrypta;
using namespace NCrypta::NSiberia;

TUpdateUserSetProcessor::TUpdateUserSetProcessor(TYdbClient& ydbClient, const TStats::TSettings& statsSettings)
    : TBase(NLog::GetLog("update_user_set"), TaggedSingleton<TStats, decltype(*this)>("processors.update_user_set", statsSettings), ydbClient)
{}

void TUpdateUserSetProcessor::DoProcess(NHttp::TRequestReply& reply, const TUpdateUserSetRequest& request) {
    Y_ENSURE(!request.UpdateInfo.Status.Defined() || request.UpdateInfo.Status == NUserSetHelpers::USER_SET_STATUS.GetReady(), "You can only set status as ready");
    UpdateUserSet(YdbClient, request.UserSetId, request.UpdateInfo);
    SendResponse(reply, HTTP_OK, NHttp::GetSimpleResponse(TStringBuilder() << "Uset set '" << request.UserSetId << "' is updated"));
}

