#include "version_request_parser.h"

#include <library/cpp/http/misc/parsed_request.h>
#include <util/string/cast.h>

using namespace NCrypta::NSiberia;

TVersionRequest TVersionRequestParser::Parse(const TString& query, const TStringBuf& body) {
    TParsedHttpLocation httpLocation(query);

    Y_ENSURE(httpLocation.Path == "/version", "Not /version request");

    return Parse(TCgiParameters(httpLocation.Cgi), body);
}

TVersionRequest TVersionRequestParser::Parse(const TCgiParameters& cgi, const TStringBuf& body) {
    Y_UNUSED(body);

    TVersionRequest request;
    request.User = cgi.Get("@client");

    return request;
}
