#include "version_request_processor.h"

#include <crypta/lib/native/http/format.h>

#include <library/cpp/svnversion/svnversion.h>

#include <util/string/builder.h>

using namespace NCrypta::NSiberia;

TVersionProcessor::TVersionProcessor(const TStats::TSettings& statsSettings)
    : TBase(NLog::GetLog("version"), TaggedSingleton<TStats, decltype(*this)>("processors.version", statsSettings))
{}

void TVersionProcessor::Process(NHttp::TRequestReply& reply, const TVersionRequest& request) {
    Y_UNUSED(request);
    SendResponse(reply, HTTP_OK, NHttp::GetSimpleResponse(TStringBuilder() << "Siberia core service\nBuilt from Arcadia rev. " << GetProgramSvnRevision()));
}
