#pragma once

#include <crypta/lib/native/http/request_reply.h>
#include <crypta/lib/native/log/log.h>
#include <crypta/lib/native/stats/stats.h>
#include <crypta/siberia/bin/core/lib/command_senders/mutation_sender.h>
#include <crypta/siberia/bin/core/lib/configs/proto/clients/client.pb.h>
#include <crypta/siberia/bin/core/lib/configs/proto/clients/clients_config.pb.h>
#include <crypta/siberia/bin/core/lib/logic/request_processor_factory.h>

#include <ydb/public/sdk/cpp/client/ydb_table/table.h>

namespace NCrypta::NSiberia {
    class TWorker {
    public:
        TWorker(TRequestProcessorFactory& requestProcessorFactory, const TClientsConfig& clientsConfig, const TStats::TSettings& statsSettings);

        void ProcessRequest(NHttp::TRequestReply& reply);

    private:
        const TClient& GetClientInfo(const TMaybe<NTvmAuth::TCheckedServiceTicket>& clientServiceTicket);
        void ReplyError(NHttp::TRequestReply& reply, HttpCodes httpCode, const TString& message);

        TRequestProcessorFactory& RequestProcessorFactory;
        const TClientsConfig& ClientsConfig;
        TStats& Stats;
        NLog::TLogPtr Log;
    };
}
