LIBRARY()

OWNER(
    g:crypta
    g:crypta-siberia
)

SRCS(
    request_processor_factory.cpp
    worker.cpp
)

PEERDIR(
    crypta/lib/native/concurrency
    crypta/lib/native/http
    crypta/lib/native/log
    crypta/lib/native/stats
    crypta/lib/native/tvm
    crypta/lib/native/ydb
    crypta/siberia/bin/core/lib/command_senders
    crypta/siberia/bin/core/lib/configs/proto
    crypta/siberia/bin/core/lib/configs/proto/clients
    crypta/siberia/bin/core/lib/logic/add_user_set
    crypta/siberia/bin/core/lib/logic/add_users
    crypta/siberia/bin/core/lib/logic/common/request_processor
    crypta/siberia/bin/core/lib/logic/describe_ids
    crypta/siberia/bin/core/lib/logic/describe_segment
    crypta/siberia/bin/core/lib/logic/describe_user_set
    crypta/siberia/bin/core/lib/logic/get_segment_stats
    crypta/siberia/bin/core/lib/logic/get_user_set
    crypta/siberia/bin/core/lib/logic/get_user_set_stats
    crypta/siberia/bin/core/lib/logic/get_user_stats
    crypta/siberia/bin/core/lib/logic/list_segment_users
    crypta/siberia/bin/core/lib/logic/make_segment
    crypta/siberia/bin/core/lib/logic/ping
    crypta/siberia/bin/core/lib/logic/remove_segments
    crypta/siberia/bin/core/lib/logic/remove_user_set
    crypta/siberia/bin/core/lib/logic/remove_user_set_data
    crypta/siberia/bin/core/lib/logic/search_segments
    crypta/siberia/bin/core/lib/logic/search_users
    crypta/siberia/bin/core/lib/logic/update_user_set
    crypta/siberia/bin/core/lib/logic/version
    crypta/siberia/bin/core/lib/ydb/requests
    library/cpp/cgiparam
    ydb/public/sdk/cpp/client/ydb_table
)

INCLUDE(${ARCADIA_ROOT}/crypta/lib/inc/yt_client.inc)

END()

RECURSE(
    add_user_set
    add_users
    common
    describe_ids
    describe_segment
    describe_user_set
    get_segment_stats
    get_user_set
    get_user_set_stats
    get_user_stats
    list_segment_users
    make_segment
    ping
    remove_segments
    remove_user_set
    remove_user_set_data
    search_segments
    search_users
    update_user_set
    version
)
