#include "parse_utils.h"

#include <crypta/siberia/bin/common/data/proto/segment.pb.h>
#include <crypta/siberia/bin/common/ydb/parse_utils/parse_utils.h>

#include <util/string/cast.h>

using namespace NCrypta::NSiberia;

namespace {
    using TAttributeMap = ::google::protobuf::Map<TProtoStringType, TUser::TInfo::TAttributeValues>;
    using TSegmentsField = ::google::protobuf::RepeatedPtrField<TSegment>;

    TUser::TInfo::TAttributeValues ParseAttributeValues(NYdb::TValueParser& attributesParser) {
        TUser::TInfo::TAttributeValues attributeValues;

        attributesParser.OpenList();

        while (attributesParser.TryNextListItem()) {
            attributesParser.OpenStruct();

            while (attributesParser.TryNextMember()) {
                if (attributesParser.GetMemberName() == "attribute_value") {
                    *attributeValues.AddValues() = *attributesParser.GetOptionalUtf8();
                }
            }

            attributesParser.CloseStruct();
        }

        attributesParser.CloseList();
        return attributeValues;
    }

    void ParseAttributes(NYdb::TValueParser& attributesParser, TAttributeMap& attributes) {
        attributesParser.OpenOptional();

        if (!attributesParser.IsNull()) {
            attributesParser.OpenDict();

            while (attributesParser.TryNextDictItem()) {
                attributesParser.DictKey();
                const auto key = *attributesParser.GetOptionalUtf8();

                attributesParser.DictPayload();
                attributes[key] = ParseAttributeValues(attributesParser);
            }

            attributesParser.CloseDict();
        }

        attributesParser.CloseOptional();
    }
}

TUsersResponse NYdbParseUtils::ParseUsers(const NYdb::NTable::TDataQueryResult& result) {
    NYdb::TResultSetParser parser(result.GetResultSet(0));

    TUsersResponse response;
    while (parser.TryNextRow()) {
        auto& user = *response.AddUsers();
        auto& info = *user.MutableInfo();

        user.SetId(ToString(*parser.ColumnParser("id").GetOptionalUint64()));
        info.SetStatus(*parser.ColumnParser("status").GetOptionalUtf8());
        ParseAttributes(parser.ColumnParser("attributes"), *info.MutableAttributes());
    }

    return response;
}
