#pragma once

#include <crypta/lib/native/ydb/types.h>
#include <crypta/lib/native/ydb/ydb_client.h>
#include <crypta/siberia/bin/common/data/proto/user_set.pb.h>
#include <crypta/siberia/bin/common/data/types.h>
#include <crypta/siberia/bin/common/ydb/paths/paths.h>

#include <ydb/public/sdk/cpp/client/ydb_driver/driver.h>
#include <ydb/public/sdk/cpp/client/ydb_table/table.h>
#include <yt/yt/core/actions/future.h>

#include <util/datetime/base.h>
#include <util/string/subst.h>

namespace NCrypta::NSiberia {
    struct TAddUserSetDbRequest {
        struct TRequestParams {
            TUserSet UserSet;
        };

        static constexpr const char* const Query = R"(
            PRAGMA TablePathPrefix("%s");

            DECLARE $user_set_id AS Uint64;
            DECLARE $user_set_title AS Utf8;
            DECLARE $expiration_time AS Uint64;
            DECLARE $type AS Utf8;
            DECLARE $status AS Utf8;

            INSERT INTO {user_sets_table} (id, title, expiration_time, type, status) VALUES ($user_set_id, $user_set_title, $expiration_time, $type, $status);
        )";

        static TString GetQuery(const TRequestParams&) {
            TString query = Query;
            SubstGlobal(query, "{user_sets_table}", YDB_PATHS.GetUserSetsTable());
            return query;
        }

        static NYdb::TParams GetParams(NYdb::TParamsBuilder&& paramsBuilder, const TRequestParams& params) {
            return paramsBuilder
                .AddParam("$user_set_id").Uint64(FromString<TUserSetId>(params.UserSet.GetId())).Build()
                .AddParam("$user_set_title").Utf8(params.UserSet.GetTitle()).Build()
                .AddParam("$expiration_time").Uint64(params.UserSet.GetExpirationTime()).Build()
                .AddParam("$type").Utf8(params.UserSet.GetType()).Build()
                .AddParam("$status").Utf8(params.UserSet.GetStatus()).Build()
                .Build();
        }
    };

    NYdb::NTable::TAsyncDataQueryResult ExecuteAddUserSetDbRequest(TYdbClient& ydbClient, const TUserSet& userSet);
    TUserSetId AddUserSet(TYdbClient& ydbClient, const TString& title, TDuration ttl, const TString& type, const TString& status);
}
