#include "describe_segment_db_request.h"

#include <crypta/lib/native/concurrency/wait_for.h>
#include <crypta/lib/native/ydb/executer.h>
#include <crypta/lib/native/ydb/helpers.h>
#include <crypta/siberia/bin/common/ydb/paths/paths.h>

using namespace NCrypta;
using namespace NCrypta::NSiberia;
using namespace NYdb::NTable;

NYdb::NTable::TAsyncDataQueryResult NSiberia::DescribeSegment(TYdbClient& ydbClient, TUserSetId userSetId, TSegmentId segmentId, TUserId lastUserId, ui64 limit, const TString& userDataTablePath) {
    return ExecuteYdbDynamicQuery<TDescribeSegmentDbRequest>(ydbClient, GetUserSetDirPath(userSetId), {.SegmentId = segmentId, .LastUserId = lastUserId, .Limit = limit, .UserDataTablePath = userDataTablePath}, NYdb::NTable::TTxSettings::StaleRO());
}

std::pair<TMaybe<TUserId>, TVector<NLab::TUserData>> NSiberia::ParseDescribeSegmentResponse(const NYdb::NTable::TDataQueryResult& result) {
    NYdb::TResultSetParser lastUserIdParser(result.GetResultSet(0));
    Y_ENSURE(lastUserIdParser.TryNextRow(), "No last user id");
    const auto& lastUserId = lastUserIdParser.ColumnParser("last_user_id").GetOptionalUint64();

    TVector<NLab::TUserData> stats;
    NYdb::TResultSetParser statsParser(result.GetResultSet(1));

    while (statsParser.TryNextRow()) {
        stats.push_back(ParseUserData(statsParser));
    }

    return {lastUserId, stats};
}
