#pragma once

#include <crypta/lib/native/ydb/types.h>
#include <crypta/lib/native/ydb/ydb_client.h>
#include <crypta/lib/proto/user_data/user_data.pb.h>
#include <crypta/siberia/bin/common/data/proto/segment.pb.h>
#include <crypta/siberia/bin/common/data/types.h>
#include <crypta/siberia/bin/common/data/proto/user.pb.h>
#include <crypta/siberia/bin/common/describing/parse_utils/user_data.h>
#include <crypta/siberia/bin/common/ydb/paths/paths.h>

#include <ydb/public/sdk/cpp/client/ydb_driver/driver.h>
#include <ydb/public/sdk/cpp/client/ydb_table/table.h>
#include <yt/yt/core/actions/future.h>

#include <util/generic/maybe.h>
#include <util/string/subst.h>

namespace NCrypta::NSiberia {
    struct TDescribeSegmentDbRequest {
        struct TRequestParams {
            TSegmentId SegmentId = 0;
            TUserId LastUserId = 0;
            ui64 Limit = 100;
            TString UserDataTablePath;
        };

        static constexpr const char* const Query = R"(
            PRAGMA TablePathPrefix("%%s");
            PRAGMA SimpleColumns = '1';

            DECLARE $segmentId AS Uint64;
            DECLARE $lastUserId AS Uint64;
            DECLARE $limit AS Uint64;

            $userIds = (
                SELECT
                    user_id
                FROM {segment_users_table}
                WHERE segment_id == $segmentId AND user_id > $lastUserId
                LIMIT $limit
            );

            $yandexuids = (
                SELECT
                    CAST(attribute_value AS Uint64) AS yandexuid
                FROM $userIds AS user_ids
                JOIN {user_attributes_table} AS user_attributes
                ON user_attributes.user_id == user_ids.user_id
                WHERE user_attributes.attribute_key == "yandexuid"
            );

            SELECT
                MAX(user_id) AS last_user_id
            FROM $userIds;

            SELECT
                *
            FROM $yandexuids AS yandexuids
            JOIN [../{user_data_table}] AS user_data
            ON yandexuids.yandexuid == user_data.yuid
        )";

        static TString GetQuery(const TRequestParams& params) {
            TString query = Query;
            SubstGlobal(query, "{segment_users_table}", YDB_PATHS.GetSegmentUsersTable());
            SubstGlobal(query, "{user_attributes_table}", YDB_PATHS.GetUserAttributesTable());
            SubstGlobal(query, "{user_data_table}", params.UserDataTablePath);
            return query;
        }

        static NYdb::TParams GetParams(NYdb::TParamsBuilder&& paramsBuilder, const TRequestParams& params) {
            return paramsBuilder
                .AddParam("$segmentId").Uint64(params.SegmentId).Build()
                .AddParam("$lastUserId").Uint64(params.LastUserId).Build()
                .AddParam("$limit").Uint64(params.Limit).Build()
                .Build();
        }
    };

    NYdb::NTable::TAsyncDataQueryResult DescribeSegment(TYdbClient& ydbClient, TUserSetId userSetId, TSegmentId segmentId, TUserId lastUserId, ui64 limit, const TString& userDataTablePath);

    std::pair<TMaybe<TUserId>, TVector<NLab::TUserData>> ParseDescribeSegmentResponse(const NYdb::NTable::TDataQueryResult& result);
}
