#include "get_segment_stats_db_request.h"

#include <crypta/lib/native/concurrency/wait_for.h>
#include <crypta/lib/native/ydb/executer.h>
#include <crypta/lib/native/ydb/helpers.h>
#include <crypta/siberia/bin/common/ydb/parse_utils/parse_utils.h>
#include <crypta/siberia/bin/common/ydb/paths/paths.h>

using namespace NCrypta;
using namespace NCrypta::NSiberia;
using namespace NYdb::NTable;

NYdb::NTable::TAsyncDataQueryResult NSiberia::ExecuteGetSegmentStatsDbRequest(TYdbClient& ydbClient, TUserSetId userSetId, TSegmentId segmentId) {
    return ExecuteYdbDynamicQuery<TGetSegmentStatsDbRequest>(ydbClient, GetUserSetDirPath(userSetId), {.SegmentId = segmentId});
}

TMaybe<NLab::TUserDataStats> NSiberia::GetSegmentStats(TYdbClient& ydbClient, TUserSetId userSetId, TSegmentId segmentId) {
    const auto result = WaitFor(ExecuteGetSegmentStatsDbRequest(ydbClient, userSetId, segmentId)).ValueOrThrow();
    ThrowOnError(result);
    return NYdbCommonParseUtils::ParseSingleUserDataStats(result.GetResultSet(0));
}
