#pragma once

#include <crypta/lab/lib/native/stats.h>
#include <crypta/lib/native/ydb/types.h>
#include <crypta/lib/native/ydb/ydb_client.h>
#include <crypta/siberia/bin/common/data/proto/segment.pb.h>
#include <crypta/siberia/bin/common/data/types.h>
#include <crypta/siberia/bin/common/ydb/paths/paths.h>

#include <ydb/public/sdk/cpp/client/ydb_driver/driver.h>
#include <ydb/public/sdk/cpp/client/ydb_table/table.h>
#include <yt/yt/core/actions/future.h>

#include <util/generic/maybe.h>
#include <util/string/subst.h>

namespace NCrypta::NSiberia {
    struct TGetSegmentStatsDbRequest {
        struct TRequestParams {
            TSegmentId SegmentId = 0;
        };

        static constexpr const char* const Query = R"(
            PRAGMA TablePathPrefix("%s");

            DECLARE $segmentId as Uint64;

            SELECT
                *
            FROM {segment_stats_table}
            WHERE segment_id == $segmentId
        )";

        static TString GetQuery(const TRequestParams&) {
            TString query = Query;
            SubstGlobal(query, "{segment_stats_table}", YDB_PATHS.GetSegmentStatsTable());
            return query;
        }

        static NYdb::TParams GetParams(NYdb::TParamsBuilder&& paramsBuilder, const TRequestParams& params) {
            return paramsBuilder
                .AddParam("$segmentId").Uint64(params.SegmentId).Build()
                .Build();
        }
    };

    NYdb::NTable::TAsyncDataQueryResult ExecuteGetSegmentStatsDbRequest(TYdbClient& ydbClient, TUserSetId userSetId, TSegmentId segmentId);
    TMaybe<NLab::TUserDataStats> GetSegmentStats(TYdbClient& ydbClient, TUserSetId userSetId, TSegmentId segmentId);
}
