#include "insert_segment_db_request.h"

#include <crypta/lib/native/concurrency/wait_for.h>
#include <crypta/lib/native/ydb/executer.h>
#include <crypta/lib/native/ydb/helpers.h>
#include <crypta/siberia/bin/common/ydb/paths/paths.h>
#include <crypta/siberia/bin/core/lib/logic/common/helpers/ids.h>

using namespace NCrypta;
using namespace NCrypta::NSiberia;
using namespace NYdb::NTable;


NYdb::NTable::TAsyncDataQueryResult NSiberia::ExecuteInsertSegmentDbRequest(TYdbClient& ydbClient, TUserSetId userSetId, const TSegment& segment) {
    return ExecuteYdbDynamicQuery<TInsertSegmentDbRequest>(ydbClient, GetUserSetDirPath(userSetId), {.Segment = segment});
}

void NSiberia::InsertSegment(TYdbClient& ydbClient, TUserSetId userSetId, TSegment& segment) {
    const auto result = RetryIfConstraintViolation([&]() {
        segment.SetId(ToString(GetNewId()));
        return WaitFor(ExecuteInsertSegmentDbRequest(ydbClient, userSetId, segment)).ValueOrThrow();
    });
    Y_ENSURE(result.Defined(), "Too many attempts to insert");
    ThrowOnError(*result);
}
