#pragma once

#include <crypta/lib/native/ydb/types.h>
#include <crypta/lib/native/ydb/ydb_client.h>
#include <crypta/siberia/bin/common/data/proto/segment.pb.h>
#include <crypta/siberia/bin/common/data/types.h>
#include <crypta/siberia/bin/common/ydb/paths/paths.h>

#include <ydb/public/sdk/cpp/client/ydb_table/table.h>
#include <yt/yt/core/actions/future.h>

#include <util/string/subst.h>

namespace NCrypta::NSiberia {
    struct TInsertSegmentDbRequest {
        struct TRequestParams {
            const TSegment& Segment;
        };

        static constexpr const char* const Query = R"(
            PRAGMA TablePathPrefix("%s");
            DECLARE $segmentData AS "Struct<
                id: Uint64,
                title: Utf8,
                rule: Utf8,
                status: Utf8,
                size: Uint64,
                creation_ts: Uint64>";

            INSERT INTO {segments_table}
            SELECT
                id,
                title,
                rule,
                status,
                size,
                creation_ts
            FROM AS_TABLE(AsList($segmentData));
        )";

        static TString GetQuery(const TRequestParams&) {
            TString query = Query;
            SubstGlobal(query, "{segments_table}", YDB_PATHS.GetSegmentsTable());
            return query;
        }

        static NYdb::TParams GetParams(NYdb::TParamsBuilder&& paramsBuilder, const TRequestParams& params) {
            return paramsBuilder
                .AddParam("$segmentData")
                .BeginStruct()
                .AddMember("id").Uint64(FromString<TUserSetId>(params.Segment.GetId()))
                .AddMember("title").Utf8(params.Segment.GetTitle())
                .AddMember("rule").Utf8(params.Segment.GetRule())
                .AddMember("status").Utf8(params.Segment.GetStatus())
                .AddMember("size").Uint64(params.Segment.GetSize())
                .AddMember("creation_ts").Uint64(params.Segment.GetCreationTs())
                .EndStruct().Build()
                .Build();
        }
    };

    NYdb::NTable::TAsyncDataQueryResult ExecuteInsertSegmentDbRequest(TYdbClient& ydbClient, TUserSetId userSetId, const TSegment& segment);
    void InsertSegment(TYdbClient& ydbClient, TUserSetId userSetId, TSegment& segment);
}
