#include "insert_users_db_request.h"

#include <crypta/lib/native/concurrency/wait_for.h>
#include <crypta/lib/native/ydb/executer.h>
#include <crypta/lib/native/ydb/helpers.h>
#include <crypta/siberia/bin/common/ydb/paths/paths.h>

using namespace NCrypta;
using namespace NCrypta::NSiberia;
using namespace NYdb::NTable;

NYdb::NTable::TAsyncDataQueryResult NSiberia::ExecuteInsertUsersDbRequest(TYdbClient& ydbClient, TUserSetId userSetId, const TVector<TUser>& users) {
    return ExecuteYdbDynamicQuery<TInsertUsersDbRequest>(ydbClient, GetUserSetDirPath(userSetId), {.Users = users});
}

void NSiberia::InsertUsers(TYdbClient& ydbClient, TUserSetId userSetId, const TVector<TUser>& users) {
    const auto result = WaitFor(ExecuteInsertUsersDbRequest(ydbClient, userSetId, users)).ValueOrThrow();
    ThrowOnError(result, "Add users error");
}
