#include "list_segment_users_db_request.h"

#include <crypta/lib/native/concurrency/wait_for.h>
#include <crypta/lib/native/ydb/executer.h>
#include <crypta/lib/native/ydb/helpers.h>
#include <crypta/siberia/bin/common/ydb/paths/paths.h>
#include <crypta/siberia/bin/core/lib/ydb/parse_utils/parse_utils.h>

using namespace NCrypta;
using namespace NCrypta::NSiberia;
using namespace NYdb::NTable;

NYdb::NTable::TAsyncDataQueryResult NSiberia::ExecuteListSegmentUsersDbRequest(TYdbClient& ydbClient, TUserSetId userSetId, TSegmentId segmentId, TUserId lastUserId, ui64 limit) {
    return ExecuteYdbDynamicQuery<TListSegmentUsersDbRequest>(ydbClient, GetUserSetDirPath(userSetId), {.SegmentId = segmentId, .LastUserId = lastUserId, .Limit = limit});
}

TUsersResponse NSiberia::GetSegmentUsers(TYdbClient& ydbClient, TUserSetId userSetId, TSegmentId segmentId, TUserId lastUserId, ui64 limit) {
    const auto result = WaitFor(ExecuteListSegmentUsersDbRequest(ydbClient, userSetId, segmentId, lastUserId, limit)).ValueOrThrow();
    ThrowOnError(result);
    return NYdbParseUtils::ParseUsers(result);
}
