#pragma once

#include <crypta/lib/native/ydb/types.h>
#include <crypta/lib/native/ydb/ydb_client.h>
#include <crypta/siberia/bin/common/data/proto/segment.pb.h>
#include <crypta/siberia/bin/common/data/types.h>
#include <crypta/siberia/bin/common/data/proto/user.pb.h>
#include <crypta/siberia/bin/common/ydb/paths/paths.h>
#include <crypta/siberia/bin/core/proto/users_response.pb.h>

#include <ydb/public/sdk/cpp/client/ydb_driver/driver.h>
#include <ydb/public/sdk/cpp/client/ydb_table/table.h>
#include <yt/yt/core/actions/future.h>

#include <util/string/subst.h>

namespace NCrypta::NSiberia {
    struct TListSegmentUsersDbRequest {
        struct TRequestParams {
            TSegmentId SegmentId = 0;
            TUserId LastUserId = 0;
            ui64 Limit = 1000;
        };

        static constexpr const char* const Query = R"(
            PRAGMA TablePathPrefix("%s");
            PRAGMA SimpleColumns = '1';

            DECLARE $segmentId AS Uint64;
            DECLARE $lastUserId AS Uint64;
            DECLARE $limit AS Uint64;

            $segmentUserIds = (
                SELECT
                    segment_users.user_id AS user_id
                FROM {segment_users_table} AS segment_users
                WHERE segment_users.segment_id == $segmentId AND user_id > $lastUserId
                LIMIT $limit
            );

            $segmentUsers = (
                SELECT
                    users.*
                FROM $segmentUserIds AS user_ids
                JOIN {users_table} AS users
                ON users.id == user_ids.user_id
            );

            $usersSegments = (
                SELECT
                    users_segment_ids.user_id as user_id,
                    LIST(AsStruct(segments.title as title, segments.status as status, segments.rule as rule, segments.id as id, segments.size as size, segments.creation_ts as creation_ts)) as segments
                FROM (
                    SELECT
                        user_segments.*
                    FROM $segmentUsers as segment_users
                    JOIN {user_segments_table} AS user_segments
                    ON segment_users.id == user_segments.user_id
                ) AS users_segment_ids
                JOIN {segments_table} AS segments
                ON users_segment_ids.segment_id == segments.id
                GROUP BY users_segment_ids.user_id
            );

            $usersAttributes = (
                SELECT
                    user_id,
                    ToDict(LIST(attributes)) as attributes
                FROM (
                    SELECT
                        user_id,
                        AsTuple(attribute_key, LIST(AsStruct(attribute_value AS attribute_value, ts AS ts))) as attributes
                    FROM (
                        SELECT
                            user_attributes.*
                        FROM $segmentUsers as segment_users
                        JOIN {user_attributes_table} AS user_attributes
                        ON segment_users.id == user_attributes.user_id
                    )
                    GROUP BY user_id, attribute_key
                )
                GROUP BY user_id
            );

            SELECT
                attributed_users.*,
                users_segments.segments AS segments
            FROM (
                SELECT
                    segment_users.*,
                    users_attributes.attributes AS attributes
                FROM $segmentUsers AS segment_users
                LEFT JOIN $usersAttributes AS users_attributes
                ON segment_users.id == users_attributes.user_id
            ) AS attributed_users
            LEFT JOIN $usersSegments as users_segments
            ON attributed_users.id == users_segments.user_id
            ORDER BY id;
        )";

        static TString GetQuery(const TRequestParams&) {
            TString query = Query;
            SubstGlobal(query, "{segment_users_table}", YDB_PATHS.GetSegmentUsersTable());
            SubstGlobal(query, "{user_segments_table}", YDB_PATHS.GetUserSegmentsTable());
            SubstGlobal(query, "{users_table}", YDB_PATHS.GetUsersTable());
            SubstGlobal(query, "{segments_table}", YDB_PATHS.GetSegmentsTable());
            SubstGlobal(query, "{user_attributes_table}", YDB_PATHS.GetUserAttributesTable());
            return query;
        }

        static NYdb::TParams GetParams(NYdb::TParamsBuilder&& paramsBuilder, const TRequestParams& params) {
            return paramsBuilder
                .AddParam("$segmentId").Uint64(params.SegmentId).Build()
                .AddParam("$lastUserId").Uint64(params.LastUserId).Build()
                .AddParam("$limit").Uint64(params.Limit).Build()
                .Build();
        }
    };

    NYdb::NTable::TAsyncDataQueryResult ExecuteListSegmentUsersDbRequest(TYdbClient& ydbClient, TUserSetId userSetId, TSegmentId segmentId, TUserId lastUserId, ui64 limit);
    TUsersResponse GetSegmentUsers(TYdbClient& ydbClient, TUserSetId userSetId, TSegmentId segmentId, TUserId lastUserId, ui64 limit);
}
