#include "remove_segments_db_request.h"

#include <crypta/lib/native/concurrency/wait_for.h>
#include <crypta/lib/native/ydb/executer.h>
#include <crypta/lib/native/ydb/helpers.h>
#include <crypta/siberia/bin/common/ydb/paths/paths.h>

using namespace NCrypta;
using namespace NCrypta::NSiberia;
using namespace NYdb::NTable;

NYdb::NTable::TAsyncDataQueryResult NSiberia::ExecuteRemoveSegmentsDbRequest(TYdbClient& ydbClient, TUserSetId userSetId, const TVector<TSegmentId>& segmentIds) {
    return ExecuteYdbDynamicQuery<TRemoveSegmentsDbRequest>(ydbClient, GetUserSetDirPath(userSetId), {.SegmentIds = segmentIds});
}

void NSiberia::RemoveSegments(TYdbClient& ydbClient, TUserSetId userSetId, const TVector<TSegmentId>& segmentIds) {
    ThrowOnError(WaitFor(ExecuteRemoveSegmentsDbRequest(ydbClient, userSetId, segmentIds)).ValueOrThrow());
}
