#pragma once

#include <crypta/lib/native/ydb/types.h>
#include <crypta/lib/native/ydb/ydb_client.h>
#include <crypta/siberia/bin/common/data/proto/segment.pb.h>
#include <crypta/siberia/bin/common/data/types.h>
#include <crypta/siberia/bin/common/ydb/paths/paths.h>

#include <ydb/public/sdk/cpp/client/ydb_driver/driver.h>
#include <ydb/public/sdk/cpp/client/ydb_table/table.h>
#include <yt/yt/core/actions/future.h>

#include <util/string/subst.h>

namespace NCrypta::NSiberia {
    struct TRemoveSegmentsDbRequest {
        struct TRequestParams {
            const TVector<TSegmentId>& SegmentIds;
        };

        static constexpr const char* const Query = R"(
            PRAGMA TablePathPrefix("%s");

            DECLARE $segmentIds AS 'List<Struct<id: Uint64>>';

            DELETE FROM {segments_table} ON
            SELECT * FROM AS_TABLE($segmentIds);

            DELETE FROM {segment_stats_table} ON
            SELECT id AS segment_id FROM AS_TABLE($segmentIds);
        )";

        static TString GetQuery(const TRequestParams&) {
            TString query = Query;
            SubstGlobal(query, "{segments_table}", YDB_PATHS.GetSegmentsTable());
            SubstGlobal(query, "{segment_stats_table}", YDB_PATHS.GetSegmentStatsTable());
            return query;
        }

        static NYdb::TParams GetParams(NYdb::TParamsBuilder&& paramsBuilder, const TRequestParams& params) {
            auto& segmentIdsParam = paramsBuilder.AddParam("$segmentIds");
            segmentIdsParam.BeginList();

            for (auto& id : params.SegmentIds) {
                segmentIdsParam.AddListItem()
                    .BeginStruct()
                    .AddMember("id").Uint64(id)
                    .EndStruct();
            }

            segmentIdsParam.EndList().Build();
            return paramsBuilder.Build();
        }
    };

    NYdb::NTable::TAsyncDataQueryResult ExecuteRemoveSegmentsDbRequest(TYdbClient& ydbClient, TUserSetId userSetId, const TVector<TSegmentId>& segmentIds);
    void RemoveSegments(TYdbClient& ydbClient, TUserSetId userSetId, const TVector<TSegmentId>& segmentIds);
}
