#include "remove_user_set_db_request.h"

#include <crypta/lib/native/concurrency/wait_for.h>
#include <crypta/lib/native/ydb/executer.h>
#include <crypta/lib/native/ydb/helpers.h>
#include <crypta/siberia/bin/common/ydb/parse_utils/parse_utils.h>

using namespace NCrypta;
using namespace NCrypta::NSiberia;
using namespace NYdb::NTable;

NYdb::NTable::TAsyncDataQueryResult NSiberia::ExecuteRemoveUserSetDbRequest(TYdbClient& ydbClient, TUserSetId userSetId) {
    return ExecuteYdbDynamicQuery<TRemoveUserSetDbRequest>(ydbClient, "", {.UserSetId = userSetId});
}

TMaybe<TUserSet> NSiberia::RemoveUserSet(TYdbClient& ydbClient, TUserSetId userSetId) {
    const auto result = WaitFor(ExecuteRemoveUserSetDbRequest(ydbClient, userSetId)).ValueOrThrow();
    ThrowOnError(result);
    return NYdbCommonParseUtils::ParseUserSet(result.GetResultSet(0));
}
