#pragma once

#include <crypta/lib/native/ydb/types.h>
#include <crypta/lib/native/ydb/ydb_client.h>
#include <crypta/siberia/bin/common/data/proto/user_set.pb.h>
#include <crypta/siberia/bin/common/data/types.h>
#include <crypta/siberia/bin/common/ydb/paths/paths.h>

#include <ydb/public/sdk/cpp/client/ydb_driver/driver.h>
#include <ydb/public/sdk/cpp/client/ydb_table/table.h>
#include <yt/yt/core/actions/future.h>

#include <util/generic/string.h>
#include <util/string/subst.h>
#include <util/system/types.h>

namespace NCrypta::NSiberia {
    struct TRemoveUserSetDbRequest {
        struct TRequestParams {
            TUserSetId UserSetId = 0;
        };

        static constexpr const char* const Query = R"(
            PRAGMA TablePathPrefix("%s");

            DECLARE $user_set_id AS Uint64;

            SELECT
                *
            FROM `{user_sets_table}`
            WHERE id == $user_set_id;

            DELETE FROM `{user_sets_table}` ON
            SELECT
                id
            FROM `{user_sets_table}`
            WHERE id == $user_set_id;

            DELETE FROM `{user_set_stats_table}` ON
            SELECT
                user_set_id
            FROM `{user_set_stats_table}`
            WHERE user_set_id == $user_set_id;
        )";

        static TString GetQuery(const TRequestParams&) {
            TString query = Query;
            SubstGlobal(query, "{user_set_stats_table}", YDB_PATHS.GetUserSetStatsTable());
            SubstGlobal(query, "{user_sets_table}", YDB_PATHS.GetUserSetsTable());
            return query;
        }

        static NYdb::TParams GetParams(NYdb::TParamsBuilder&& paramsBuilder, const TRequestParams& params) {
            return paramsBuilder
                .AddParam("$user_set_id").Uint64(params.UserSetId).Build()
                .Build();
        }
    };

    NYdb::NTable::TAsyncDataQueryResult ExecuteRemoveUserSetDbRequest(TYdbClient& ydbClient, TUserSetId userSetId);
    TMaybe<TUserSet> RemoveUserSet(TYdbClient& ydbClient, TUserSetId userSetId);
}
