#include "save_segment_stats_db_request.h"

#include <crypta/lib/native/concurrency/wait_for.h>
#include <crypta/lib/native/ydb/executer.h>
#include <crypta/lib/native/ydb/helpers.h>
#include <crypta/siberia/bin/common/ydb/paths/paths.h>

using namespace NCrypta;
using namespace NCrypta::NSiberia;
using namespace NYdb::NTable;

NYdb::NTable::TAsyncDataQueryResult NSiberia::ExecuteSaveSegmentStatsDbRequest(TYdbClient& ydbClient, TUserSetId userSetId, TSegmentId segmentId, const NLab::TUserDataStats& stats) {
    return ExecuteYdbDynamicQuery<TSaveSegmentStatsDbRequest>(ydbClient, GetUserSetDirPath(userSetId), {.SegmentId = segmentId, .Stats = stats});
}

void NSiberia::SaveSegmentStats(TYdbClient& ydbClient, TUserSetId userSetId, TSegmentId segmentId, const NLab::TUserDataStats& stats) {
    const auto result = WaitFor(ExecuteSaveSegmentStatsDbRequest(ydbClient, userSetId, segmentId, stats)).ValueOrThrow();
    if (!result.IsSuccess()) {
        Cout << "Fail" << Endl;
        Cout << result.GetIssues().ToString() << Endl;
    }
}
