#pragma once

#include <crypta/lib/native/ydb/types.h>
#include <crypta/lib/native/ydb/ydb_client.h>
#include <crypta/lib/proto/user_data/user_data_stats.pb.h>
#include <crypta/siberia/bin/common/data/proto/segment.pb.h>
#include <crypta/siberia/bin/common/data/types.h>
#include <crypta/siberia/bin/common/ydb/paths/paths.h>

#include <ydb/public/sdk/cpp/client/ydb_driver/driver.h>
#include <ydb/public/sdk/cpp/client/ydb_table/table.h>
#include <yt/yt/core/actions/future.h>

#include <util/string/subst.h>

namespace NCrypta::NSiberia {
    struct TSaveSegmentStatsDbRequest {
        struct TRequestParams {
            TSegmentId SegmentId = 0;
            const NLab::TUserDataStats& Stats;
        };

        static constexpr const char* const Query = R"(
            PRAGMA TablePathPrefix("%s");

            DECLARE $segmentId as Uint64;
            DECLARE $stats AS String;

            UPSERT INTO {segment_stats_table} (segment_id, stats)
            VALUES ($segmentId, $stats);
        )";

        static TString GetQuery(const TRequestParams&) {
            TString query = Query;
            SubstGlobal(query, "{segment_stats_table}", YDB_PATHS.GetSegmentStatsTable());
            return query;
        }

        static NYdb::TParams GetParams(NYdb::TParamsBuilder&& paramsBuilder, const TRequestParams& params) {
            TString stats;
            Y_PROTOBUF_SUPPRESS_NODISCARD params.Stats.SerializeToString(&stats);

            return paramsBuilder
                .AddParam("$segmentId").Uint64(params.SegmentId).Build()
                .AddParam("$stats").String(stats).Build()
                .Build();
        }
    };

    NYdb::NTable::TAsyncDataQueryResult ExecuteSaveSegmentStatsDbRequest(TYdbClient& ydbClient, TUserSetId userSetId, TSegmentId segmentId, const NLab::TUserDataStats& stats);
    void SaveSegmentStats(TYdbClient& ydbClient, TUserSetId userSetId, TSegmentId segmentId, const NLab::TUserDataStats& stats);
}
