#include "search_segments_db_request.h"

#include <crypta/lib/native/concurrency/wait_for.h>
#include <crypta/lib/native/ydb/executer.h>
#include <crypta/lib/native/ydb/helpers.h>
#include <crypta/siberia/bin/common/ydb/paths/paths.h>
#include <crypta/siberia/bin/common/ydb/parse_utils/parse_utils.h>

using namespace NCrypta;
using namespace NCrypta::NSiberia;
using namespace NYdb::NTable;

NYdb::NTable::TAsyncDataQueryResult NSiberia::ExecuteSearchSegmentsDbRequest(TYdbClient& ydbClient, TUserSetId userSetId, TSegmentId lastSegmentId, ui64 limit) {
    return ExecuteYdbDynamicQuery<TSearchSegmentsDbRequest>(ydbClient, GetUserSetDirPath(userSetId), {.LastSegmentId = lastSegmentId, .Limit = limit});
}

TSegments NSiberia::SearchSegments(TYdbClient& ydbClient, TUserSetId userSetId, TSegmentId lastSegmentId, ui64 limit) {
    const auto result = WaitFor(ExecuteSearchSegmentsDbRequest(ydbClient, userSetId, lastSegmentId, limit)).ValueOrThrow();
    ThrowOnError(result);
    return ParseSearchSegmentsResult(result);
}

TSegments NSiberia::ParseSearchSegmentsResult(const TDataQueryResult& result) {
    TSegments segments;
    NYdb::TResultSetParser parser(result.GetResultSet(0));

    while (parser.TryNextRow()) {
        *segments.AddSegments() = NYdbCommonParseUtils::ParseSegment(parser);
    }

    return segments;
}
